/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.client.render.RenderConfigs;
import dev.toma.gunsrpg.client.render.item.S12KRenderer;
import dev.toma.gunsrpg.common.IShootProps;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.init.ModSounds;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.item.guns.AbstractShotgun;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoMaterials;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponBuilder;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponCategory;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class S12KItem
extends AbstractShotgun {
    private static final ResourceLocation RELOAD = GunsRPG.makeResource("s12k/reload");
    private static final ResourceLocation UNJAM = GunsRPG.makeResource("s12k/unjam");
    private static final ResourceLocation EJECT = GunsRPG.makeResource("s12k/eject");
    private static final ResourceLocation[] AIM = new ResourceLocation[]{GunsRPG.makeResource("s12k/aim"), GunsRPG.makeResource("s12k/aim_red_dot")};

    public S12KItem(String name) {
        super(name, new Item.Properties().setISTER(() -> S12KRenderer::new).func_200918_c(370));
    }

    @Override
    public int getPelletCount(LivingEntity shooter, ItemStack stack) {
        return 6;
    }

    @Override
    public void initializeWeapon(WeaponBuilder builder) {
        builder.category(WeaponCategory.SG).config(GunsRPG.config.weapon.s12k).ammo().define(AmmoMaterials.WOOD, 0).define(AmmoMaterials.STONE, 1).define(AmmoMaterials.IRON, 2).define(AmmoMaterials.LAPIS, 1).define(AmmoMaterials.GOLD, 3).define(AmmoMaterials.REDSTONE, 2).define(AmmoMaterials.EMERALD, 5).define(AmmoMaterials.QUARTZ, 4).define(AmmoMaterials.DIAMOND, 6).define(AmmoMaterials.AMETHYST, 8).define(AmmoMaterials.NETHERITE, 10).build();
    }

    @Override
    protected boolean isSilenced(PlayerEntity player) {
        return PlayerData.hasActiveSkill(player, Skills.S12K_SUPPRESSOR);
    }

    @Override
    protected SoundEvent getShootSound(PlayerEntity entity) {
        return this.isSilenced(entity) ? ModSounds.GUN_S12K_SILENCED : ModSounds.GUN_S12K;
    }

    @Override
    public int getReloadTime(IAttributeProvider provider, ItemStack stack) {
        return Attribs.S12K_RELOAD.intValue(provider);
    }

    @Override
    public int getFirerate(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.S12K_FIRERATE).intValue();
    }

    @Override
    public int getMaxAmmo(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.S12K_MAG_CAPACITY).intValue();
    }

    @Override
    public float getVerticalRecoil(IAttributeProvider provider) {
        return Attribs.S12K_VERTICAL.floatValue(provider);
    }

    @Override
    public float getHorizontalRecoil(IAttributeProvider provider) {
        return Attribs.S12K_HORIZONTAL.floatValue(provider);
    }

    @Override
    public double getNoiseMultiplier(IAttributeProvider provider) {
        return Attribs.S12K_NOISE.value(provider);
    }

    @Override
    protected float getInaccuracy(IShootProps props, LivingEntity entity) {
        float spread = super.getInaccuracy(props, entity);
        if (entity instanceof PlayerEntity && PlayerData.hasActiveSkill((PlayerEntity)entity, Skills.S12K_CHOKE)) {
            spread *= 0.7f;
        }
        return spread;
    }

    @Override
    public void onKillEntity(AbstractProjectile bullet, LivingEntity victim, ItemStack stack, LivingEntity shooter) {
        if (shooter instanceof PlayerEntity && PlayerData.hasActiveSkill((PlayerEntity)shooter, Skills.S12K_NEVER_GIVE_UP)) {
            shooter.func_195064_c(new EffectInstance(Effects.field_76429_m, 100, 0, false, false));
        }
    }

    @Override
    protected int getShootAnimationLength(PlayerEntity player) {
        return 4;
    }

    @Override
    public int getUnjamTime(ItemStack stack) {
        return 70;
    }

    @Override
    public SkillType<?> getRequiredSkill() {
        return Skills.S12K_ASSEMBLY;
    }

    @Override
    public ResourceLocation getReloadAnimation(PlayerEntity player) {
        return RELOAD;
    }

    @Override
    public ResourceLocation getUnjamAnimationPath() {
        return UNJAM;
    }

    @Override
    public ResourceLocation getBulletEjectAnimationPath() {
        return EJECT;
    }

    @Override
    public ResourceLocation getAimAnimationPath(ItemStack stack, PlayerEntity player) {
        return AIM[PlayerData.hasActiveSkill(player, Skills.S12K_RED_DOT) ? 1 : 0];
    }

    @Override
    public IRenderConfig left() {
        return RenderConfigs.S12K_LEFT;
    }

    @Override
    public IRenderConfig right() {
        return RenderConfigs.S12K_RIGHT;
    }
}

